/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : platform_config.h
* Author             : MCD Application Team
* Version            : V2.0.1
* Date               : 06/13/2008
* Description        : Evaluation board specific configuration file.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __PLATFORM_CONFIG_H
#define __PLATFORM_CONFIG_H

/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Uncomment the line corresponding to the STMicroelectronics evaluation board
   used to run the example */

#if !defined (USE_STM3210B_EVAL)
 #define USE_STM3210B_EVAL
#endif

/* Define For ET-STM32F103 Board */
#ifdef USE_STM3210B_EVAL

  // Define LCD-16x2 PinIO Interface Mask Bit 
  #define  LCD_EN_PIN		           GPIO_Pin_10			// EN = PC[10]
  #define  LCD_EN_PORT		           GPIOC
  #define  RCC_APB2Periph_GPIO_EN      RCC_APB2Periph_GPIOC

  #define  LCD_RW_PIN		           GPIO_Pin_11			// RW = PC[11]
  #define  LCD_RW_PORT	               GPIOC
  #define  RCC_APB2Periph_GPIO_RW      RCC_APB2Periph_GPIOC

  #define  LCD_RS_PIN 		       	   GPIO_Pin_12			// RS= PC[12]
  #define  LCD_RS_PORT		           GPIOC
  #define  RCC_APB2Periph_GPIO_RS      RCC_APB2Periph_GPIOC

  #define  LCD_D4_PIN 		       	   GPIO_Pin_3			// D4 = PC[3]
  #define  LCD_D5_PIN 		       	   GPIO_Pin_2			// D5 = PC[2]
  #define  LCD_D6_PIN 		       	   GPIO_Pin_1			// D6 = PC[1]
  #define  LCD_D7_PIN 		       	   GPIO_Pin_0			// D7 = PC[0]
  #define  LCD_DATA_PORT	           GPIOC
  #define  RCC_APB2Periph_GPIO_DATA    RCC_APB2Periph_GPIOC

  #define  LCD_EN_HI()    	           GPIO_WriteBit(LCD_EN_PORT,LCD_EN_PIN,Bit_SET)
  #define  LCD_EN_LO()		           GPIO_WriteBit(LCD_EN_PORT,LCD_EN_PIN,Bit_RESET)

  #define  LCD_RW_HI()    	           GPIO_WriteBit(LCD_RW_PORT,LCD_RW_PIN,Bit_SET)  
  #define  LCD_RW_LO() 		           GPIO_WriteBit(LCD_RW_PORT,LCD_RW_PIN,Bit_RESET)

  #define  LCD_RS_HI() 	               GPIO_WriteBit(LCD_RS_PORT,LCD_RS_PIN,Bit_SET)
  #define  LCD_RS_LO() 	               GPIO_WriteBit(LCD_RS_PORT,LCD_RS_PIN,Bit_RESET)

  #define  LCD_D4_HI() 	               GPIO_WriteBit(LCD_DATA_PORT,LCD_D4_PIN,Bit_SET)
  #define  LCD_D4_LO() 	               GPIO_WriteBit(LCD_DATA_PORT,LCD_D4_PIN,Bit_RESET)

  #define  LCD_D5_HI() 	               GPIO_WriteBit(LCD_DATA_PORT,LCD_D5_PIN,Bit_SET)
  #define  LCD_D5_LO() 	               GPIO_WriteBit(LCD_DATA_PORT,LCD_D5_PIN,Bit_RESET)

  #define  LCD_D6_HI() 	               GPIO_WriteBit(LCD_DATA_PORT,LCD_D6_PIN,Bit_SET)
  #define  LCD_D6_LO() 	               GPIO_WriteBit(LCD_DATA_PORT,LCD_D6_PIN,Bit_RESET)

  #define  LCD_D7_HI() 	               GPIO_WriteBit(LCD_DATA_PORT,LCD_D7_PIN,Bit_SET)
  #define  LCD_D7_LO() 	               GPIO_WriteBit(LCD_DATA_PORT,LCD_D7_PIN,Bit_RESET)

  #define  lcd_clear()                 lcd_write_control(0x01)	// Clear Display
  #define  lcd_cursor_home()           lcd_write_control(0x02)	// Set Cursor = 0
  #define  lcd_display_on()            lcd_write_control(0x0E)	// LCD Display Enable
  #define  lcd_display_off()           lcd_write_control(0x08)	// LCD Display Disable
  #define  lcd_cursor_blink()          lcd_write_control(0x0F)	// Set Cursor = Blink
  #define  lcd_cursor_on()             lcd_write_control(0x0E)	// Enable LCD Cursor
  #define  lcd_cursor_off()            lcd_write_control(0x0C)	// Disable LCD Cursor
  #define  lcd_cursor_left()           lcd_write_control(0x10)	// Shift Left Cursor
  #define  lcd_cursor_right()          lcd_write_control(0x14)	// Shift Right Cursor
  #define  lcd_display_sleft()         lcd_write_control(0x18)	// Shift Left Display
  #define  lcd_display_sright()        lcd_write_control(0x1C)	// Shift Right Display
  
#endif /* USE_STM3210B_EVAL */

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

#endif /* __PLATFORM_CONFIG_H */

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
